require( "scripts/style.lua" );

require( "scripts/basicSetting.lua");

guestCreationDelay = 42000;
guestCreationSpeedIncrease = 1600;
minGuestsToCreate = 4;
maxGuestsToCreate = 6;

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 3;


levelSetting1 = 
{	
	-- total of 100%
	guestListPercentage = 
	{
		female01Percent=10,
		female02Percent=10,
		female03Percent=10,
		female04Percent=10,
		male01Percent=10,
		male02Percent=10,
		male03Percent=10,
		male04Percent=10,
		unclePercent=10,
		auntPercent=10
	},
	
	guestAttributes = 
	{
	-- low to high range
	-- percentage from 0 to 100
		tolerance =		{50000, 70000},
		waitBeforeSit =		{1000, 1000},
		waitBeforeAppetizer =	{1000, 1000},
		waitBeforeDinner =	{8000, 8000},
		waitBeforeCake =	{10000, 10000},
		waitBeforeGift =	{1000, 1000},
		percentRequestDrink =	{0, 10},
		percentRequestMusic =	{0, 10},
		percentRequestResit =	{0, 5},
		percentRequestCoffee =	{10, 50},
		percentRequestTissue =	{10, 50}
	}
}




dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();
LManager:SetLevelNumber(5,1);

LManager:AddNewTable( 1, 6, 200, 220, "assets/images/table/redtable_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 2, 175, 350, "assets/images/table/bluetable_2", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 4, 310, 350, "assets/images/table/redtable", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 4, 8, 200, 485, "assets/images/table/bluetable_8", "assets/images/food/item_mark4", "B" );

LManager:SetLevelSetting ("bridesmaidsDelay", 400000);
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 300000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 500000);
LManager:SetLevelSetting ("speakerChance", 60);

LManager:SetLevelSetting ("blaster", 1);

-- Testing...
LManager:SetLevelSetting( "guestLeaveAllow", 5 );

gameObject = LManager:GenerateGameObject();

levelSetting = LManager:GenerateLevelSettings();
levelSetting.mode = "endless";
levelSetting.passScore = 
	{
	    700 -- the base score. for each level the passScore is baseScore + baseScore*level*level
	};
	
--dofile( "scripts/LevelDialogGenerator.lua" );

LManager:SetChairImage("assets/images/table/chair05");

MakeDialog
{

	Bitmap
	{
		name="backgroundimage",
		image="images/bg_castle",
				
		GameWindow
		{ 	
			x = 0, y = 0, w = kMax, h = kMax,
			Button{
			x=800, y=600, --set offscreen
			--x=140,
			--y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="upgrade",
			label="upgradetitle",
			type = kPush,
			command = 
				function()
				    OpenArcadeUpgrade();
				end
				
			};			
		},
		-- the pause button
		Button{
			x=10,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="pause",
			label="ui.dialog.pause.title",
			type = kPush,
			command = 
				function()
				    DoPause();
				end
				
		};
	},
	
}
